'use strict';

var _createClass = function () { function defineProperties(target, props) { for (var i = 0; i < props.length; i++) { var descriptor = props[i]; descriptor.enumerable = descriptor.enumerable || false; descriptor.configurable = true; if ("value" in descriptor) descriptor.writable = true; Object.defineProperty(target, descriptor.key, descriptor); } } return function (Constructor, protoProps, staticProps) { if (protoProps) defineProperties(Constructor.prototype, protoProps); if (staticProps) defineProperties(Constructor, staticProps); return Constructor; }; }();

function _classCallCheck(instance, Constructor) { if (!(instance instanceof Constructor)) { throw new TypeError("Cannot call a class as a function"); } }

/**
 * Created by jack on 2017/6/7.
 */

(function ($) {
    var read = null,
        EFFECT_ANIMATE = null;
    // qs_c_obj.isLogin = true;
    var baseUrl = qs_c_obj.isDebug ? '/api' : '';
    var REQUEST = {
        getBookData: function getBookData() {
            return $.getJSON(baseUrl + ('/Public/bookcontent/' + pageObj.staticFile));
        },
        getContent: function getContent(data) {
            return $.ajax({
                url: baseUrl + '/Readdoc/getContent_2',
                type: 'post',
                data: data,
                dataType: 'json'
            });
        },
        getOrData: function loadOrData() {
            return $.ajax({
                type: "post",
                url: baseUrl + "/Readdoc/getOrData",
                data: {
                    id: pageObj.bookid
                },
                dataType: "JSON"
            });
        },
        checkBuy: function checkBuy() {
            return $.ajax({
                url: baseUrl + '/Readdoc/checkBuy/',
                method: 'post',
                data: { id: pageObj.bookid },
                dataType: 'json'
            });
        },
        readAgain: function readAgain(fn) {
            return $.ajax({
                type: "post",
                url: baseUrl + "/Readdoc/setReadOver",
                data: { id: pageObj.bookid },
                dataType: "JSON",
                success: function success() {
                    typeof fn == 'function' && fn();
                }
            });
        },
        doMark: function doMark() {
            return $.ajax({
                type: "post",
                url: baseUrl + "/Person/doMarkBook",
                data: { bookid: pageObj.bookid },
                dataType: "JSON"
            });
        },
        wxPay: function wxPay() {
            $.ajax({
                type: "get",
                url: qs_c_obj.host + "Wxpay/native_2/bid/" + pageObj.bookid,
                success: function success(res) {
                    // let qr = $('.qr');
                    // $('.mask').css('display', 'flex');
                    // qr.show();
                    // $('.qr-desc', qr).html(`￥ <span>${pageObj.price}</span>`);
                    // $(".qr-box", qr).empty().qrcode(res.url);
                    var fg = $(document.createDocumentFragment()).qrcode(res.url),
                        img = $('img', fg).get(0);
                    read.showQr({
                        title: '微信扫码支付',
                        desc: '\uFFE5 <span>' + pageObj.price + '</span>',
                        img: img
                    });
                }
            });
        },
        getReadCount: function getReadCount(data) {
            return $.ajax({
                url: baseUrl + '/readdoc/getEndData',
                type: 'post',
                data: data,
                dataType: 'json'
            });
        },

        getAward: function getAward(data) {
            return $.ajax({
                url: baseUrl + '/readdoc/getAward',
                data: data,
                type: 'post',
                dataType: 'json'
            });
        },
        mobile_wx_pay: function mobile_wx_pay() {
            return $.ajax({
                url: baseUrl + '/Wxpay/jsapi_2/bid/',
                data: {
                    bid: pageObj.bookid
                },
                type: 'post',
                dataType: 'json'
            });
        },
        changeLoadMode: function changeLoadMode() {
            return $.ajax({
                url: '/readdoc/changeReadMode/',
                type: 'post',
                data: {
                    id: pageObj.bookid
                }
            });
        },
        chooseBack: function chooseBack(data) {
            return $.ajax({
                url: '/readdoc/useHhy',
                type: 'post',
                data: data,
                dataType: 'json'
            });
        }
    };

    jQuery.ajaxSetup({
        ifModify: true
    });

    /**
     * 阅读主体
     */

    var READ = function () {
        function READ() {
            _classCallCheck(this, READ);

            /*添加2个loader 为了消除 common.js inzit函数提前消除loading动画*/
            qs_c_obj.setCookie('qs_backUrl', location.href, 0.1);
            qs_c_obj.getCookie('qs_clear_bid') && qs_c_obj.setCookie('qs_clear_bid', '', 0); //登陆是否清除阅读记录
            this.dom = $('#readCont');
            this.isMark = pageObj.isMark == 2;
            this.shareObj = {
                id: pageObj.bookid,
                title: pageObj.bookname,
                desc: pageObj.bookdesc,
                // url: qs_c_obj.host + "read/" + pageObj.bookid + ".html",
                url: location.origin + '?share=1',
                img: pageObj.pic ? pageObj.pic : qs_c_obj.shareImg
            };
            this.bookdata = null;
            this.orData = null;
            this.orView = [];
            this.currentOr = null;
            this.isLoad = false;
            this.isEnd = false;
            this.isTebShow = true;
            this.canLoad = true;
            this.firstLoad = true;
            this.loadTime = 500;
            this.titleShow = true; //是否显示标题
            this.likeCount = pageObj.mark_count;
            this.commentCount = pageObj.comm_count;
            this.isApp = pageObj.isApp; //是否是app模式进入
            this.back_count = qs_c_obj.isLogin ? qs_c_obj.userInfo.hhy_cnt : 0; //后悔药数量
            this.loadMethod = pageObj.animate ? 1 : 0; //1打字机0正常一次性加载
            this.activePrint = null; //正在打字机加载的对象
            this.audio = null;
            this.redPag = null;
            this.shareTimes = 0; //分享次数
            this.process = null; //阅读进度显示对象

            this.read_history = null; //已经阅读的or

            this.init();
        }

        _createClass(READ, [{
            key: 'init',
            value: function init() {
                this.renderMark();
                this.readMode = pageObj.animate ? 1 : 0;
                if (qs_c_obj.isMobile()) {
                    //推荐文章标题
                    $('.recommend_title a').text('全部');
                    this.clickEvent = 'touchend';
                    $('.icon-weichat').parent().parent().hide();
                } else {
                    this.clickEvent = 'click';
                }
                $('.link-comment').attr('href', '/comment/' + pageObj.bookid + '.html').find('.icon').text(this.commentCount);
                this.rendTitle();
                this.showShare();
                this.bindEvent();
                this.share();

                /*初始化加载模式*/
                var md = this.loadMethod;
                for (var i in pageObj.label) {
                    var item = pageObj.label[i];
                    if (item.name == '对话体') {
                        md = true;
                    }
                }
                if (pageObj.animate) {
                    this.readMode = 0;
                }
                /*夜间模式切换*/
                this.switch(true);

                // this.changeLoadMode(md, true);
                // this.changeLoadMode(1, true);

                this.getBook();
            }

            /**
             * 活动图标
             */

        }, {
            key: 'rendTitle',
            value: function rendTitle() {
                var dom = this.dom,
                    title = $('#title');
                title.text(pageObj.bookname);
                $('.author_name').text(pageObj);
                var imgBox = $('.r-author-img');
                if (pageObj.author_img) {
                    var url = pageObj.author_img;
                    url = url.indexOf('http') >= 0 ? url : 'http://img.qiaobooks.com/' + url;
                    imgBox.prop('class', 'r-author-img author-head-img').find('img.author-img').prop('src', url);
                } else {
                    imgBox.prop('class', 'r-author-img author-head-p').find('span.author-img').text(pageObj.author.substr(0, 1));
                }

                var utime = $('.r-author-time');
                utime.text(pageObj.utime.replace(/\s*\/\s*/ig, '.'));
            }

            /**
             * 绑定事件
             */

        }, {
            key: 'bindEvent',
            value: function bindEvent() {
                if (qs_c_obj.isMobile()) {
                    qs_c_obj.bindEvent(EVENT.mbEvent);
                } else {
                    qs_c_obj.bindEvent(EVENT.pcEvent);
                }
            }

            /**
             * 获取书本信息json
             */

        }, {
            key: 'getBook',
            value: function getBook() {
                var that = this;
                // REQUEST.getOrData().done(function (res) {
                //     if (res.status == 1) {
                //         that.orData = res.data;
                //         that.read_history = new Set(res.readed_or);
                //         that.process = new READ_PROCESS(res, pageObj.or_count);
                //     } else {
                //         that.orData = [];
                //     }

                that.orData = [];
                that.read_history = new Set();
                // that.process = new READ_PROCESS(res, pageObj.or_count);
                /*是否显示标题*/
                that.titleShow = true;

                // REQUEST.getBookData().done(function (data) {
                var data = bookData; //json
                that.bookdata = data;
                that.render();
                that.startShow();
                var chooseInfo = qs_c_obj.getCookie('qs_pay_history');
                chooseInfo = chooseInfo && chooseInfo.split('_');
                if (chooseInfo && chooseInfo[0] == pageObj.bookid) {
                    qs_c_obj.setCookie('qs_pay_history', '', 0);
                    if (chooseInfo.length > 2) {
                        var id = chooseInfo[1] == that.currentOr.id[0] ? that.currentOr.id[0] : null;
                        id = id || null;
                        var _data = data[id];
                        var type = chooseInfo[2];
                        if (id) that.currentOr.handle(null, _data);
                        if (type == 0) {
                            that.test = new WEICHAT_PAY(that, _data);
                        } else {
                            location.href = qs_c_obj.host + 'Alipay/pay/bid/' + pageObj.bookid + '/from/m';
                        }
                    } else {
                        var _id = chooseInfo[1] == that.currentOr.id[0] ? that.currentOr.id[0] : null;
                        _id = _id || null;
                        var _data2 = data[_id];
                        if (_id) {
                            that.currentOr.handle(null, _data2);
                        }
                    }
                } else {
                    qs_c_obj.setCookie('qs_pay_history', '', 0);
                }
                // });
                // })
            }

            /**
             * 格式化数据，实例化VIEW
             */

        }, {
            key: 'render',
            value: function render() {
                var arr = [],
                    content = {},
                    bookData = this.bookdata,
                    start = bookData[1];
                if (start) {
                    render(start);
                }
                this.bookView = content;

                function render(data1, data2) {
                    /*避免重复创建段落节点*/
                    if (arr.indexOf(data1.bid) >= 0) {
                        return;
                    }
                    ;
                    if (data2 && arr.indexOf(data2.bid) >= 0) {
                        return;
                    }
                    ;
                    arr.push(data1.bid);
                    data2 && arr.push(data2.bid);
                    /*避免重复创建段落节点*/

                    var sItem = bookData[data1.sid],
                        sItem2 = data2 && bookData[data2.sid];
                    if (data1.type == 1) {
                        content[data1.bid] = new VIEW(data1);
                        if (sItem) {
                            if (sItem.type == 1) {
                                render(sItem);
                            } else {
                                var gItem = bookData[sItem.gid];
                                render(sItem, gItem);
                            }
                        }
                    } else {
                        var or = new VIEW(data1, data2);
                        if (data1.price) {
                            or.price = data1.price;
                        }
                        content[data1.bid] = content[data2.bid] = or;
                        if (sItem) {
                            render(sItem);
                        }
                        if (sItem2) {
                            render(sItem2);
                        }
                    }
                }
            }

            /**
             * 开始渲染初始章节
             */

        }, {
            key: 'startShow',
            value: function startShow() {
                var view = this.bookView,
                    or = this.orData,
                    needJump = false,
                    start = view[1];
                if (!start) return;
                this.showList = [];
                var history = null;
                if (or.length > 0) {
                    history = view[or[or.length - 1]];
                    start = history || start;
                    this.showNext(start, history ? or[or.length - 1] : undefined);
                } else {
                    //noinspection JSValidateTypes
                    $(".read-title").show();
                    this.showNext(start);
                }
                // this.updateView();
                this.orBtnRender();
                if (history && this.loadMethod == 0) this.orView[this.orView.length - 1].scrollTo();
                this.ready = true;
                $('body').removeLoader(true);

                /*向上加载触发事件以及移动端导航显示事件*/
                if (!qs_c_obj.isMobile()) {
                    this.scroll();
                } else {
                    this.tapScreen();
                }
            }

            /**
             * 向下加载
             * @param data  章节数据
             * @param id    （可选）or选中id
             */

        }, {
            key: 'showNext',
            value: function showNext(data, id) {
                var that = this,
                    fg = document.createDocumentFragment(),
                    view = this.bookView,
                    or = this.orData,
                    showList = this.showList;

                if (this.loadMethod == 0) {
                    next(data, id);
                    this.dom.find('.read-content').append(fg);
                } else {
                    showList.push(data);
                    if (data.type == 1) {
                        this.activePrint = new PRINTOUT(this, data, true);
                    } else {
                        this.orView.push(data);
                        this.currentOr = data;
                        this.dom.find('.read-content').append(data.dom);
                        data.insertDom = data.dom; //记录被插入节点集合
                        if (id) {
                            var lr = data.id.indexOf(id);
                            data.active(lr, 'or-active', 'or-active-back');
                            this.showNext(this.bookView[this.bookdata[id].sid]);
                        }
                    }
                }

                function next(data, id) {
                    if (data.type == 1) {
                        var sItem = view[data.data.sid];
                        showList.push(data);
                        fg.appendChild(data.dom);
                        data.insertDom = data.dom; //记录被插入文档的节点集合
                        if (sItem) {
                            if (sItem.type == 1) {
                                next(sItem);
                            } else {
                                that.orView.push(sItem);
                                that.currentOr = sItem;
                                var index = or.indexOf(sItem.id[0]) || or.indexOf(sItem.id[1]);
                                if (index >= 0) {
                                    next(sItem, or[index]);
                                } else {
                                    showList.push(sItem);
                                    fg.appendChild(sItem.dom);
                                    sItem.insertDom = sItem.dom; //记录被插入文档的节点集合
                                }
                            }
                        } else {
                            that.showEnd(data);
                        }
                    } else {
                        if (id) {
                            var _sItem = void 0,
                                _index2 = void 0;
                            // data.activeId = id;
                            _index2 = id == data.id[0] ? 0 : 1;
                            _sItem = view[data.data[_index2].sid];
                            data.active(_index2, 'or-active', 'or-active-back');

                            if (that.orView.indexOf(data) < 0) {
                                that.orView.push(data);
                            }
                            showList.push(data);
                            fg.appendChild(data.dom);
                            data.insertDom = data.dom; //记录被插入文档的节点集合
                            next(_sItem);
                        } else {
                            that.orView.push(data);
                            that.currentOr = data;
                            showList.push(data);
                            fg.appendChild(data.dom);
                            data.insertDom = data.dom; //记录被插入文档的节点集合
                        }
                    }
                }
            }

            /*显示结尾*/

        }, {
            key: 'showEnd',
            value: function showEnd(data, fn) {
                this.isEnd = true;
                var that = this,
                    params = {
                    id: pageObj.bookid,
                    pid: data.id
                };
                var end = $(".read-end");
                // REQUEST.getReadCount(params).done(function (res) {
                var state = false;
                if (data.data.end) {
                    state = true;
                    $('.end-tip', end).show().html('' + data.data.end.replace('**', ' <span class="end-count">' + 1 + '</span> ')).show();
                } else {
                    $('.end-tip', end).hide();
                }
                // if (res.award) {
                //     that.redPag = new RED_PAG(end, data, that.orData.slice(), res);
                // }

                var history = $('.end-history', end),
                    html = '' + (pageObj.language ? '共<span class="history-count"> 1 </span>人到过此结局' : 'There are<span class="history-count"> 1 </span>people ahead of you.');
                // html = `共<span class="history-count"> 1 </span>人到过此结局`;
                // html = ``;
                // user = res.user;

                //显示历史记录阅读者头像
                // user.forEach(function(v,i){
                //     console.log(v,i);
                //     html += v.head_img ? `<a href="/${v.id}/book.html"><img class="history-item" alt="${v.nick_name}" src="${v.head_img}"></a>` :`<a href="/${v.id}/book.html"><span class="history-item">${v.nick_name.slice(0,1)}</span></a>`;
                //     if(i==4){
                //         html += `<a href="/"><span class="history-link"></span></a>`;
                //     }
                // })

                state ? history.hide() : history.empty().show().html(html);

                end.show();
                $('.recommend').show();
                typeof fn == 'function' && fn();
                // });
            }
        }, {
            key: 'backStep',
            value: function backStep() {
                var that = this,
                    orData = this.orData,
                    showList = this.showList.slice().reverse(),

                // currentOr = this.currentOr,
                orView = this.orView,
                    end_view = orView[orView.length - 1],
                    index = 0,
                    or_index = 0;
                this.orData = orData.slice(0, orData.length - 1);

                /*当阅读已经最后一个or是已选择（结束或者游戏阅读）*/
                if (this.isEnd || end_view.activeId) {
                    or_index = 1;
                }
                var _iteratorNormalCompletion = true;
                var _didIteratorError = false;
                var _iteratorError = undefined;

                try {
                    for (var _iterator = showList[Symbol.iterator](), _step; !(_iteratorNormalCompletion = (_step = _iterator.next()).done); _iteratorNormalCompletion = true) {
                        var item = _step.value;

                        if (or_index >= 2) {
                            break;
                        }
                        index++;
                        if (item.type == 2) {
                            or_index++;
                            item.unActive();
                            if (or_index == 1) {
                                item.remove();
                                that.orView = orView.slice(0, orView.length - 1);
                            } else {
                                that.currentOr = item;
                            }
                            if (that.isEnd) {
                                that.isEnd = false;
                                $('.read-end').hide();
                                $('.recommend').hide();
                            }
                        } else {
                            $(item.insertDom).remove();
                        }
                    }
                } catch (err) {
                    _didIteratorError = true;
                    _iteratorError = err;
                } finally {
                    try {
                        if (!_iteratorNormalCompletion && _iterator.return) {
                            _iterator.return();
                        }
                    } finally {
                        if (_didIteratorError) {
                            throw _iteratorError;
                        }
                    }
                }

                var curr = this.currentOr,
                    pre = curr.preItem();
                if (pre) {
                    var lr = pre.id.indexOf(pre.activeId) > 0 ? 1 : 0;
                    // id = pre.activeId;
                    pre.unActive();
                    // pre.activeId = id;
                    pre.active(lr, 'or-active', 'or-active-back');
                }
                var pItem = this.bookView[curr.data[0].pid];
                if (orView.indexOf(curr) == 0 && this.showList.indexOf(pItem) < 0) {
                    this.showPre(pItem); //向上加载
                }
                this.showList = showList.slice(index - 1).reverse();
            }

            /**
             * 向上加载 同向下加载
             * @param data
             * @param id
             */

        }, {
            key: 'showPre',
            value: function showPre(data, id) {
                var that = this,
                    dom = this.dom,
                    fg = document.createDocumentFragment(),
                    view = this.bookView,
                    or = this.orData,
                    showList = this.showList;
                pre(data, id);
                $('.read-content', dom).prepend(fg);

                function pre(data, id) {
                    if (data.type == 1) {
                        var pItem = view[data.data.pid];
                        showList.unshift(data);
                        if (fg.firstChild) {
                            fg.insertBefore(data.dom, fg.firstChild);
                        } else {
                            fg.appendChild(data.dom);
                        }
                        if (pItem) {
                            if (pItem.type == 1) {
                                pre(pItem);
                            } else {
                                var activeId = or.indexOf(pItem.id[0]) >= 0 ? pItem.id[0] : pItem.id[1];
                                pre(pItem, activeId);
                            }
                        } else {
                            $('.read-title').show();
                            that.titleShow = true;
                        }
                    } else {
                        // data.activeId = id;
                        read.orView.unshift(data);

                        if (id == data.id[0]) {
                            data.active(0);
                        } else {
                            data.active(1);
                        }
                        if (fg.firstChild) {
                            fg.insertBefore(data.dom, fg.firstChild);
                        } else {
                            fg.appendChild(data.dom);
                        }
                        showList.unshift(data);
                    }
                    data.insertDom = data.dom; //记录被插入节点集合
                }
            }

            /**
             * 弃用   刷新节点
             */

        }, {
            key: 'updateView',
            value: function updateView() {
                var end = $('.overTxt'),
                    fg = document.createDocumentFragment();
                this.showList.forEach(function (v) {
                    fg.appendChild(v.dom);
                });
                end.before(fg);
                this.orBtnRender();
            }

            /**
             * 显示收费按钮
             * @param data
             */

        }, {
            key: 'showPay',
            value: function showPay(data) {
                var that = this,
                    redPag_desc = '支付后可获得一次探索机会',
                    redPag = pageObj.redPag || [];

                // var dom = this.pay = $('<div class="pay"><p class="desc">支付后可阅读本作品所有结局</p><p class="price"><strong>&yen;&nbsp;<span></span></strong></p><ul class="buy"><li class="btn btn-alipay">支付宝</li><li class="oricon"></li><li class="btn btn-weiChat">微信钱包</li><li class="btn btn-login">登录并购买</li></ul></div>');
                var dom = this.pay = $('<div class="pay">\n            <p class="pay-desc">\u652F\u4ED8\u540E\u53EF\u9605\u8BFB\u672C\u4F5C\u54C1\u6240\u6709\u7ED3\u5C40</p>\n            <p class="pay-price"><strong>\xA5 <span>' + pageObj.price + '</span></strong></p>\n            <ul class="pay-buy">\n            <li class="btn btn-default buy-alipay">\u652F\u4ED8\u5B9D</li>\n            <li class="btn btn-default buy-weichat">\u5FAE\u4FE1\u94B1\u5305</li>\n            <li class="btn btn-default buy-login">\u767B\u5F55\u5E76\u8D2D\u4E70</li>\n            </ul>\n            </div>');
                // $('.price', dom).find('span').html(data.price);
                $('.buy-login', dom).on(that.clickEvent, function () {
                    if (qs_c_obj.isMobile()) {
                        if (!qs_c_obj.isLogin) {
                            if (qs_c_obj.isWeichat()) {
                                qs_c_obj.setCookie('qs_pay_history', pageObj.bookid + '_' + data.activeId + '_0', 0.1);
                                location.href = '/User/tlogin/t/Wechat';
                            } else {
                                qs_c_obj.setCookie('qs_pay_history', pageObj.bookid + '_' + data.activeId + '_1', 0.1);
                                location.href = qs_c_obj.mhost + 'login.html';
                            }
                            // that.jumpToLogin();
                        } else {
                            var ua = navigator.userAgent.toLowerCase();
                            if (ua.match(/MicroMessenger/i) == "micromessenger") {
                                // location.href = qs_c_obj.host + 'Wxpay/jsapi/bid/' + pageObj.bookid;
                                that.test = new WEICHAT_PAY(that, data);
                            } else {
                                location.href = qs_c_obj.host + 'Alipay/pay/bid/' + pageObj.bookid + '/from/m';
                            }
                        }
                    } else {
                        qs_c_obj.setCookie('qs_pay_history', pageObj.bookid + '_' + data.activeId, 0.1);
                        qs_c_obj.showLoginWin(function () {
                            setTimeout(function () {
                                that.checkPay(that.activeView);
                            }, 600);
                            // $('.buy li').eq(3).hide().siblings().show();
                        });
                    }
                });
                $('.buy-alipay', dom).on(that.clickEvent, function () {
                    window.open(qs_c_obj.host + "Alipay/pay/bid/" + pageObj.bookid + "/from/p");
                    _checkPay();
                });
                $('.buy-weichat', dom).on(that.clickEvent, function () {
                    $("#pcpaywx").show();
                    REQUEST.wxPay();
                    var img = new Image();
                    img.src = '/Public/img/read_icon/payDone.png';
                    _checkPay(function (res) {
                        if (res.status == 1) {
                            $('.shareewm').find('img').replaceWith(img);
                            setTimeout(function () {
                                $('#pcpaywx').hide();
                            }, 1000);
                        }
                    });
                });

                /*红包活动修改支付介绍*/
                if (pageObj.bookid.toString() in redPag) {
                    $('.pay-desc', dom).text(redPag_desc);
                }

                if (qs_c_obj.isMobile()) {
                    var btn = $('.buy-login', dom);
                    btn.text('立即支付');
                    btn.css({
                        'display': 'inline-block',
                        'margin-right': '0'
                    });
                    btn.siblings().hide();
                } else {
                    if (qs_c_obj.isLogin) {
                        $('.buy-login', dom).hide().siblings().css('display', 'inline-block');
                    } else {
                        $('.buy-login', dom).css('display', 'inline-block');
                        $('.buy-login', dom).siblings().hide();
                    }
                }

                function _checkPay(fn, time) {
                    if (that.timer) clearTimeout(that.timer);
                    that.timer = setTimeout(function () {
                        REQUEST.checkBuy().done(function (res) {
                            if (typeof fn == 'function') {
                                fn(res);
                            }
                            if (res.status == 1) {
                                clearTimeout(that.timer);
                                that.checkPay(that.activeView);
                            } else {
                                _checkPay(fn);
                            }
                        }).fail(function () {
                            _checkPay(fn);
                        });
                    }, 3000);
                }

                data.dom.appendChild(dom.get(0));
            }

            /**
             * 请求是否是收费节点
             * @param view
             */

        }, {
            key: 'checkPay',
            value: function checkPay(view) {
                $('.pay').remove();
                var that = this,
                    lr = view.id[0] == view.activeId ? 0 : 1,
                    data = view.data[lr],
                    sItem = this.bookView[data.sid];

                var or = this.orData.slice();
                or.push(view.id[lr]);
                // let params = {
                //     bookid: pageObj.bookid,
                //     or: or,
                // };

                if (that.pay) {
                    $('.pay').remove();
                }
                view.click = false;
                that.orData = or;
                that.showNext(sItem);
                $(view.dom).removeLoader2();
                that.orBtnRender();
                $('.qr .close').click();
                // if (that.process) {
                //     that.process.update(res.read_per, view, lr);
                // }

                // REQUEST.getContent(params).done(function (res) {
                //     if (res.status === 1) {
                //         if (that.pay) {
                //             $('.pay').remove();
                //         }
                //         view.click = false;
                //         that.orData = or;
                //         that.showNext(sItem);
                //         $(view.dom).removeLoader2();
                //         that.orBtnRender();
                //         $('.qr .close').click();
                //         if (that.process) {
                //             that.process.update(res.read_per, view, lr);
                //         }
                //     } else if(res.status === 3){
                //         that.activeView = view;
                //         view.price = res.price;
                //         view.click = true;//不可点击状态
                //         that.showPay(view);
                //         $(view.dom).removeLoader2();
                //     }else if(res.status === 4){
                //         qs_c_obj.showLoginWin(()=>{
                //             that.checkPay(view);
                //         });
                //         $('#alertExit').on('click',()=>{
                //             $('.pay').remove();
                //             view.unActive(true);
                //             $(view.dom).removeLoader2();
                //             view.click = false;
                //         })
                //     }else{
                //         setTimeout(()=>{
                //             that.checkPay(view);
                //         },2000);
                //         console.warn('请求失败正在重新请求.......');
                //     }
                // });
            }

            /**
             * pc端滑动加载
             */

        }, {
            key: 'scroll',
            value: function scroll() {
                if (this.isLoad) return;
                var that = this,
                    view = this.bookView,
                    currScrollTop = 0;
                $(window).scroll(function () {
                    var top = qs_c_obj.platformInfo.browser == 'Firefox' ? document.documentElement.scrollTop : document.body.scrollTop;
                    // that.showShare();

                    /*加载*/
                    var showList = that.showList,
                        first = showList[0];
                    if (that.ready && top == 0 && first.type != 1 && !that.isLoad && currScrollTop != 0) {
                        that.isLoad = true;
                        var curr = showList[0],
                            pItem = view[curr.data[0].pid];
                        $(curr.dom).loader2(true);

                        /*上下控制or记录*/
                        that.currentOr = curr;
                        /*上下控制or记录*/

                        setTimeout(function () {
                            that.isLoad = false;
                            if (pItem) that.showPre(pItem);
                            $(curr.dom).removeLoader2();
                            curr.scrollTo(1, "130");
                            that.orBtnRender();
                        }, that.loadTime);
                    }
                    currScrollTop = top; //用于判断是否第一次滚动（ff浏览器的坑爹bug）
                });
            }

            /**
             * 喜欢
             */

        }, {
            key: 'doMark',
            value: function doMark() {
                var that = this;
                if (this.isMark) return;
                REQUEST.doMark().done(function (res) {
                    if (res.status == 1) {
                        that.isMark = false;
                        that.likeCount = res.mark_cnt;
                        that.renderMark(false);
                    } else if (res.status == 2) {
                        that.isMark = true;
                        that.likeCount = res.mark_cnt;
                        that.renderMark(true);
                    } else {
                        if (qs_c_obj.isMobile()) {
                            that.jumpToLogin();
                        } else {
                            qs_c_obj.showLoginWin();
                        }
                    }
                });
            }
        }, {
            key: 'readAgain',
            value: function readAgain() {
                REQUEST.readAgain().done(function () {
                    /*清除滚动条历史纪录*/
                    if (qs_c_obj.isWeichat()) {
                        var href = location.href;
                        // location.href = href + ('?refresh=' + Math.random() * 100000);
                        location.href = href.indexOf('?') >= 0 ? href + ('&refresh=' + Math.random() * 100000) : href + ('?refresh=' + Math.random() * 100000);
                    } else {
                        location.assign(location.href);
                        setTimeout(function () {
                            location.reload();
                        }, 500);
                    }
                });
            }

            /**
             * 喜欢成功，取消成功样式渲染
             * @param type
             */

        }, {
            key: 'renderMark',
            value: function renderMark(type) {
                var nav = $('#nav'),
                    count_dom = $('.like-count');
                if (type === undefined) {
                    type = this.isMark;
                }
                if (!type) {
                    $('.icon-liked').removeClass('icon-liked').addClass('icon-like');
                    count_dom.text(this.likeCount);
                } else {
                    $('.icon-like').removeClass('icon-like').addClass('icon-liked');
                    count_dom.text(this.likeCount);
                }
            }

            /**
             * 阅读模式切换
             * @param init
             */

        }, {
            key: 'switch',
            value: function _switch(init) {
                var mode = this.readMode,
                    result = null;
                mode == null && (mode = 1);

                var night = {
                    bodyClass: 'dark',
                    iconClass: 'icon icon-light',
                    text: "白天",
                    code: '2'
                };
                var day = {
                    bodyClass: '',
                    iconClass: 'icon icon-dark',
                    text: "夜间",
                    code: '1'
                };
                if (mode == 1) {
                    result = init == true ? day : night;
                } else {
                    result = init == true ? night : day;
                }

                // $("#orimg").attr("src", src);
                // $("body,#readCont,#read_botton,#nav")[method]("night");
                this.readMode = result.code;
                $('body').prop('class', result.bodyClass);
                $('#dark').find('.icon').prop('class', result.iconClass).text(result.text);
                EFFECT_ANIMATE || qs_c_obj.setCookie("qs_c_read_mode", result.code, 30);
            }

            /**
             * 阅读模式切换
             * @param mode(需要加载的模式)
             * @param isFirst(是否第一次加载，否则会通知服务器手动切换了一次)
             *
             */

        }, {
            key: 'changeLoadMode',
            value: function changeLoadMode(mode, isFirst) {
                var className = 'load-item-active';
                mode = mode == 1 ? 1 : 0;
                this.loadMethod = mode;
                var dom = $('.menu-loadMode').eq(0),
                    btn1 = $('.load-item-left', dom),
                    btn2 = $('.load-item-right', dom),
                    btn = mode == 0 ? btn1 : btn2;
                $('.' + className, dom).removeClass(className);
                btn.addClass(className);
                EFFECT_ANIMATE || qs_c_obj.setCookie("qs_c_load_mode", mode);
                !isFirst && REQUEST.changeLoadMode();
            }

            /**
             * 向上向下滑动选择or
             * @param index
             */

        }, {
            key: 'orSelect',
            value: function orSelect(index) {
                var orView = this.orView,
                    view,
                    length = this.orView.length,
                    i = orView.indexOf(this.currentOr);
                switch (index) {
                    case 0:
                        {
                            if (i > 0) {
                                view = orView[i - 1];
                                view.scrollTo(null, 8);
                                this.currentOr = view;
                                this.orBtnRender();
                            }
                            break;
                        }
                    case 1:
                        {
                            if (length > 1 && i < length - 1) {
                                view = orView[i + 1];
                                view.scrollTo(null, 8);
                                this.currentOr = view;
                                this.orBtnRender();
                            }
                            break;
                        }
                    case 2:
                        {
                            if (length > 1) {
                                view = this.orView[this.orView.length - 1];
                                view.scrollTo(null, 8);
                                this.currentOr = view;
                                this.orBtnRender();
                            } else {
                                view = this.orView[0];
                                view.scrollTo(null, 8);
                                this.currentOr = view;
                                this.orBtnRender();
                            }
                            break;
                        }
                }
            }

            /**
             * 渲染相上下选择or按钮样式
             */

        }, {
            key: 'orBtnRender',
            value: function orBtnRender() {
                var orNumber = this.orView.indexOf(this.currentOr),
                    dom = $(".branch-control").find("li"),
                    className = "disable";
                if (orNumber == 0) {
                    if (!dom.eq(0).hasClass(className)) dom.eq(0).addClass(className);
                } else {
                    if (dom.eq(0).hasClass(className)) dom.eq(0).removeClass(className);
                }
                if (orNumber == this.orView.length - 1) {
                    if (!dom.eq(1).hasClass(className)) dom.eq(1).addClass(className);
                } else {
                    if (dom.eq(1).hasClass(className)) dom.eq(1).removeClass(className);
                }
                if (orNumber < 0) {
                    dom.eq(0).addClass(className);
                    dom.eq(1).addClass(className);
                }
            }

            /**
             * mb端登陆跳转
             *
             */

        }, {
            key: 'jumpToLogin',
            value: function jumpToLogin(params) {
                var url = window.location.href;
                var pageName = url.replace(qs_c_obj.mhost, "");
                if (pageName != "login.html" && pageName != "register.html") {
                    qs_c_obj.setCookie("qs_backUrl", url, 0.1);
                }
                // let href = qs_c_obj.mhost + 'login.html' + (typeof params == 'object') ? '?' + $.param(params) : '';
                location.href = qs_c_obj.mhost + 'login.html';
            }
        }, {
            key: 'share',
            value: function share() {
                var obj = this.shareObj;
                var url1 = 'http://sns.qzone.qq.com/cgi-bin/qzshare/cgi_qzshare_onekey?style=203&width=98&height=22&otype=share',
                    url2 = 'http://service.weibo.com/share/share.php?appkey=197649834&language=zh_cn';
                url1 += "&url=" + encodeURIComponent(obj.url);
                url1 += "&desc=" + encodeURIComponent(obj.desc);
                url1 += "&title=" + encodeURIComponent(obj.title);
                url1 += "&summery=&pics=" + encodeURIComponent(obj.img);
                url1 += "&pic=" + encodeURIComponent(obj.img);
                //
                url2 += "&url=" + encodeURIComponent(obj.url);
                url2 += "&desc=" + encodeURIComponent(obj.title);
                url2 += "&title=" + encodeURIComponent(obj.desc);
                url2 += "&summery=&pics=" + encodeURIComponent(obj.img);
                url2 += "&pic=" + encodeURIComponent(obj.img);
                $('.link-qzone').prop('href', url1);
                $('.link-weibo').prop('href', url2);
            }
        }, {
            key: 'showQr',
            value: function showQr() {
                var obj = arguments.length > 0 && arguments[0] !== undefined ? arguments[0] : { title: '微信扫码支付', desc: '', img: null, close: null };

                var qr = $('.qr'),
                    mask = $('.mask');
                mask.css({
                    display: 'flex'
                });
                mask.addClass('fadeIn');
                qr.show().addClass('fadeIn-down');
                setTimeout(function () {
                    mask.removeClass('fadeIn');
                    qr.removeClass('fadeIn-down');
                }, 200);
                $('.qr-title', qr).text(obj.title);
                $('.qr-desc', qr).html(obj.desc);
                $('.qr-box', qr).empty().append(obj.img);
                $('.close', qr).off().on('click', function () {
                    qr.addClass('fadeOut-down');
                    mask.addClass('fadeOut');

                    setTimeout(function () {
                        mask.css({
                            display: 'none'
                        });
                        qr.hide();
                        if (obj.close && typeof obj.close == 'function') {
                            obj.close();
                        }
                        qr.removeClass('fadeOut-down');
                        mask.removeClass('fadeOut');
                    }, 200);
                });
            }
        }, {
            key: 'showTeb',
            value: function showTeb(type) {
                var nav = $('#nav'),
                    menu = $('#read-menu');
                this.isTebShow = type;
                if (type) {
                    nav.show();
                    menu.show();
                    nav.addClass('fadeIn-pull');
                    menu.addClass('fadeIn-push');
                    setTimeout(function () {
                        nav.removeClass('fadeIn-pull');
                        menu.removeClass('fadeIn-push');
                    }, 200);
                } else {
                    nav.addClass('fadeOut-push');
                    menu.addClass('fadeOut-pull');
                    this.showBranch(false);
                    setTimeout(function () {
                        nav.removeClass('fadeOut-push');
                        menu.removeClass('fadeOut-pull');
                        nav.hide();
                        menu.hide();
                    }, 200);
                }
            }
        }, {
            key: 'showBranch',
            value: function showBranch(type) {
                var branch = $('.branch-control');
                if (type) {
                    branch.show();
                    branch.addClass('fadeIn-down');
                    setTimeout(function () {
                        branch.removeClass('fadeIn-down');
                    }, 200);
                } else {
                    branch.addClass('fadeOut-down');
                    setTimeout(function () {
                        branch.removeClass('fadeOut-down');
                        branch.hide();
                    }, 200);
                }
                type = type ? type.toString() : '';
                branch.data('flag', type);
            }
        }, {
            key: 'showShare',
            value: function showShare() {
                /*显示分享*/
                var isEnd = this.isEnd,
                    top = document.body.scrollTop,
                    share = $('.read-share'),
                    wHeight = window.innerHeight,
                    bHeight = $('body').height(),
                    offsetTop = isEnd ? $('.end-menu').offset().top : bHeight;

                if (top > 64) {
                    if (top + wHeight >= offsetTop && isEnd) {
                        share.css({
                            left: -168,
                            top: offsetTop - wHeight + 35 /*fixed 转absolute 误差*/
                        }).prop('class', 'read-share read-share-absolute');
                    } else {
                        share.css({
                            left: this.dom.offset().left - 168,
                            top: 173
                        }).prop('class', 'read-share read-share-fixed');
                    }
                } else {
                    share.css({
                        left: this.dom.offset().left - 168,
                        top: 173
                    }).prop('class', 'read-share read-share-fixed');
                }
            }

            /**
             * 移动端控制导航显示隐藏
             */

        }, {
            key: 'tapScreen',
            value: function tapScreen() {
                var that = this,
                    $box = $('.read'),
                    _top = 0;

                $box.on('touchstart.tap', function (e) {
                    _top = e.originalEvent.touches[0].clientY;
                    var state = false;
                    $box.one('touchend.tap', function (e) {
                        if (state) {
                            e.stopPropagation();
                            state = false;
                        }
                    }).one('touchmove.tap', function (e) {
                        state = true;
                        var touch = e.originalEvent.touches[0],
                            top = touch.clientY;

                        if (_top - top > 3 && that.isTebShow) {
                            //向下
                            that.showTeb(false);
                        } else if (top - _top > 3 && !that.isTebShow) {
                            //向上
                            that.showTeb(true);
                        }
                        _top = top;
                    });
                });
            }
        }, {
            key: 'chooseBack',
            value: function chooseBack() {
                var _this = this;

                var that = this;
                // if(false){

                if (this.loadMethod == 1 && this.activePrint && this.activePrint.isLoading) {
                    return;
                }

                if (!qs_c_obj.isLogin) {
                    if (qs_c_obj.isMobile()) {
                        this.jumpToLogin();
                    } else {
                        qs_c_obj.showLoginWin(function () {
                            _this.back_count = qs_c_obj.userInfo.hhy_cnt;
                            _this.chooseBack();
                        });
                    }
                    return;
                }

                if (this.back_count > 0) {
                    $.confirm({
                        fn: function fn(type) {
                            if (type) {
                                REQUEST.chooseBack({
                                    id: pageObj.bookid,
                                    or: that.orData.slice(0, that.orData.length - 1)
                                }).done(function (res) {
                                    if (res.status == 0) {
                                        console.error('后悔药投放失败');
                                    } else if (res.status == 1) {
                                        // location.reload();
                                        that.backStep();
                                        that.back_count--;
                                        $('body').toast('<span>\u4F7F\u7528\u6210\u529F\uFF0C\u8FD4\u56DE\u4E0A\u4E00\u4E2A\u9009\u62E9\uFF01</span><br>\n                                    <span style="margin-top: 8px; display: block">\u6545\u4E8B\u53EF\u4EE5\u91CD\u6765\uFF0C\u4F46\u4EBA\u751F\u4E0D\u884C\u3002<br>\n                                        \u8BF7\u614E\u91CD\u4F60\u7684\u9009\u62E9\u3002</span>');
                                    } else {
                                        console.warn('后悔药使用完！');
                                    }
                                });
                            }
                        },

                        obj: {
                            title: '确定要使用后悔药吗？',
                            content: '\u5F53\u524D\u62E5\u6709\u540E\u6094\u836F x ' + this.back_count + ' \u7C92\u3002<br>\n                             <span style="color: #9AA5AF;">\u6BCF\u5929\u767B\u5F55\u90FD\u80FD\u5F97\u5230 1 \u7C92\u540E\u6094\u836F\u54E6\uFF01</span>',
                            btn: ['我再想想', '确定使用']
                        }
                    });
                } else {
                    $.confirm({
                        fn: null,
                        obj: {
                            title: 'Oops！没有后悔药了！',
                            content: '\u6545\u4E8B\u53EF\u4EE5\u91CD\u6765\uFF0C\u4F46\u4EBA\u751F\u4E0D\u884C\u3002<br>\u8BF7\u614E\u91CD\u4F60\u7684\u9009\u62E9\u3002<br>\n                             <span style="color: #9AA5AF;">\u6BCF\u5929\u767B\u5F55\u90FD\u80FD\u5F97\u5230 1 \u7C92\u540E\u6094\u836F\u54E6\uFF01</span>',
                            btn: ['默默放弃', '无法使用']
                        }
                    });
                    $('.qs_alert  .btn-default').addClass('disable');
                }
            }
        }]);

        return READ;
    }();

    /**
     * 节点对象
     * @param data1 （必填）数据
     * @param data2     （可选）当类型为or是需要2个参数实例化为同一个对象
     * @constructor
     */

    var VIEW = function () {
        function VIEW(data1, data2) {
            _classCallCheck(this, VIEW);

            this.feature = null;
            this.event = qs_c_obj.isMobile() ? "touchend" : 'click';
            if (data1.type == 1) {
                this.createP(data1);
                this.data = data1;
                this.type = 1;
                this.id = data1.bid;
            } else {
                this.type = 2;
                this.id = [data1.bid, data2.bid];
                this.createOr(data1, data2);
                this.data = [data1, data2];
                this.activeId = false;
            }
            this.click = false; //控制点击之后后台返回数据之前不让再次点击  read.checkPay控制值的变化
            this.needPay = false; //是否需要支付
            this.isShow = false;
            this.insertDom = null; //段落有两套节点  用于存放被插入文档的节点集合
        }

        _createClass(VIEW, [{
            key: 'remove',
            value: function remove() {
                this.dom.remove();
            }
        }, {
            key: 'createP',
            value: function createP(data) {
                var content = data.content,
                    content_list = [],
                    arr = content.split('\n');

                var div = document.createElement('div');
                arr.forEach(function (v, i) {
                    var item = $.trim(v) ? marked(v) : '<p class="read-text" data-id="' + data.bid + '">' + v + '</p>';
                    var dom = $(item).addClass('read-text').get(0);
                    var _dom = dom.cloneNode(true);
                    content_list.push(dom);

                    /*特效扫描*/
                    EFFECT_ANIMATE && EFFECT_ANIMATE.scan(dom, _dom);

                    div.appendChild(_dom);
                });
                this.dom = div;
                $(div).css({
                    backgroundColor: 'transparent'
                });
                this.content_list = content_list;

                // this.strToDom(html);
                // arr.forEach((v, i)=>{
                //     let item = $.trim(v) ? marked(v) : `<p class="read-text" data-id="${data.bid}">${v}</p>`;
                //     content_list.push($(item).get(0));
                //     arr[i] = item;
                // });
                // html = `<div>${arr.join('')}</div>`;
                // this.content_list = content_list;

                // this.strToDom(html);
            }
        }, {
            key: 'createOr',
            value: function createOr(data1, data2) {
                var that = this,
                    finger = false,
                    html = '<div class="btn-or">\n                <p class="or-desc">' + (pageObj.language ? '做出你的选择' : 'Make your choice!') + '</p>\n                <ul class="clear">\n                    <li class="or or-btn or-left" data-id="' + data1.bid + '">\n                        <div class="or-box" style="background-position: ' + this.random(2) + '% ' + this.random(2) + '%">\n                            <span class="or-content">' + data1.content + '</span>\n                        </div>\n                        <div class="or-back">\n                            <p>\u540E\u6094\u4E86?\u60F3\u91CD\u9009\u4E00\u6B21?<br><span>\u4F7F\u7528\u540E\u6094\u836F</span></p>\n                            <!--<button class="btn btn-default">\u70B9\u51FB\u4F7F\u7528\u540E\u6094\u836F</button>-->\n                        </div>\n                    </li>\n                    <li class="or or-img icon icon-or"></li>\n                    <li class="or or-btn or-right" data-id="' + data2.bid + '">\n                        <div class="or-box" style="background-position: ' + this.random(2) + '% ' + this.random(2) + '%">\n                            <span class="or-content">' + data2.content + '</span>\n                        </div>\n                        <div class="or-back">\n                            <p>\u540E\u6094\u4E86?\u60F3\u91CD\u9009\u4E00\u6B21?<br><span>\u4F7F\u7528\u540E\u6094\u836F</span></p>\n                            <!--<button class="btn btn-default">\u70B9\u51FB\u4F7F\u7528\u540E\u6094\u836F</button>-->\n                        </div>\n                    </li>\n                </ul>\n            </div>';
                this.strToDom(html);
                var left = this.left = this.dom.querySelector('.or-left'),
                    right = this.right = this.dom.querySelector('.or-right');
                if (qs_c_obj.isMobile()) {
                    bindE(left, function (e) {
                        that.handle(e, data1);
                    });
                    bindE(right, function (e) {
                        that.handle(e, data2);
                    });
                } else {
                    left.addEventListener(this.event, function (e) {
                        that.handle(e, data1);
                    });
                    right.addEventListener(this.event, function (e) {
                        that.handle(e, data2);
                    });
                    // $('.or-back .btn',this.dom).on('click',function(e){
                    //     e.stopPropagation();
                    //     read.chooseBack()
                    // })
                }
                // function handle(e, data) {
                //     if (that.activeId == false) {
                //         e.stopPropagation();
                //         $(that.dom).loader2();
                //         that.activeId = data.bid;
                //         var lr = that.id[0] == data.bid ? 0 : 1;
                //         that.active(lr);
                //         read.checkPay(that, data)
                //     }
                // }

                function bindE(dom, fn) {
                    var move = false;
                    $(dom).on('touchmove.mb', function () {
                        move = true;
                    }).on("touchend.mb", function (e) {
                        if (move && that.activeId == false) {
                            /*拖动触发点击*/
                            //当按钮没有选择or时touchmove阻止 反之不阻止
                            move = false;
                            return false;
                        } else {
                            move = false;
                            fn.call(this, e);
                        }
                    });
                }
            }
        }, {
            key: 'random',
            value: function random(num, fix) {
                num = num || 0;
                fix = fix || 0;
                return Math.random().toFixed(num + fix) * Math.pow(10, num || 0);
            }
        }, {
            key: 'handle',
            value: function handle(e, data) {
                if (this.click) return;
                this.click = true;
                if (this.activeId === false) {
                    e && e.stopPropagation();
                    $(this.dom).loader2();
                    // this.activeId = data.bid;
                    var lr = this.id[0] == data.bid ? 0 : 1;
                    this.clear_back(); //清除之前的back按钮
                    this.active(lr, 'or-active', 'or-active-back');
                    read.checkPay(this, data);
                } else {
                    this.click = false;
                    var dom = $(e.currentTarget);
                    if (dom.hasClass('or-active-back')) {
                        e.stopPropagation();
                        read.chooseBack();
                        return false;
                    }
                }
            }
        }, {
            key: 'clear_back',
            value: function clear_back() {
                $('.or-active-back').removeClass('or-active-back').addClass('or-blur');
            }
        }, {
            key: 'active',
            value: function active(lr) {
                var classActive = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : 'or-active';
                var classUnActive = arguments.length > 2 && arguments[2] !== undefined ? arguments[2] : 'or-blur';

                classActive = 'or-active';
                classUnActive = 'or-blur';
                if (this.type == 2) {
                    if (lr === 0) {
                        this.left.classList.add(classActive);
                        this.right.classList.add(classUnActive);
                        $(this.left).find('.or-box').addClass('or-finger');
                    } else {
                        this.right.classList.add(classActive);
                        this.left.classList.add(classUnActive);
                        $(this.right).find('.or-box').addClass('or-finger');
                    }
                    this.activeId = this.id[lr];
                }
            }
        }, {
            key: 'unActive',
            value: function unActive(type) {
                // this.left.classList.remove('or-active');
                // this.right.classList.remove('or-blur');
                // this.right.classList.remove('or-active');
                // this.left.classList.remove('or-blur');
                $('.or-btn', this.dom).removeClass('or-active').removeClass('or-active-back').removeClass('or-blur');
                this.activeId = false;
                if (type) {
                    $(this.dom).find('.or-finger').removeClass('or-finger');
                }
            }

            /**
             * 滑动至or
             * @param time
             * @param offset
             */

        }, {
            key: 'scrollTo',
            value: function scrollTo(time, offset) {
                var top = this.dom.offsetTop,
                    height = $(window).height();
                time = time ? time : 300;
                if (offset) {
                    if (typeof offset == 'number') {
                        top = top - height / offset;
                    } else if (typeof offset == 'string') {
                        top = top - offset;
                    }
                }
                var body = qs_c_obj.platformInfo.browser == 'Firefox' ? document.documentElement : document.body; //兼容ff
                $(body).animate({
                    scrollTop: top
                }, time);
            }
        }, {
            key: 'strToDom',
            value: function strToDom(str) {
                var vDom = document.createElement('div');
                vDom.innerHTML = str;
                // $(vDom).find('p').addClass('read-text');
                // $(vDom).find('h1').addClass('read-text');
                this.dom = vDom.firstElementChild.cloneNode(true);
            }
        }, {
            key: 'preItem',
            value: function preItem() {
                var data_all = read.bookdata,
                    data_view = read.bookView,
                    data_item = this.data,
                    result = null;
                if (this.type == 2) {
                    data_item = data_item[0];
                }
                pre(data_item);

                function pre(data) {
                    if (!data) return;
                    var item = data_all[data.pid];
                    if (item) {
                        if (item.type == 2) {
                            result = data_view[item.bid];
                        } else if (item.type == 3) {
                            result = data_view[item.gid];
                        } else {
                            pre(item);
                        }
                    }
                }

                return result;
            }
        }]);

        return VIEW;
    }();

    /**
     * 结尾红包
     */


    var RED_PAG = function () {
        /**
         * 红包
         * @param end 结尾区域节点
         * @param data 结尾数据
         * @param orData or历史数据
         * @param res getEnd返回数据
         */
        function RED_PAG(end, data, orData, res) {
            _classCallCheck(this, RED_PAG);

            $('.end-btn', end).hide();
            var html = '<div class="red-pag">\n                <p class="red-pag-title">\u606D\u559C\u4F60\u83B7\u5F97\u968F\u673A\u7EA2\u5305</p>\n                <p class="red-pag-try">\u8BD5\u8BD5\u624B\u6C14~</p>\n                <div class="red-pag-money"><span></span>\u5143</div>\n                <p class="red-pag-desc"><a href=\'/feeList.html\'>\u5DF2\u653E\u5165\u60A8\u7684\u94B1\u5305</a></p>\n                <span class="btn btn-clear">\u518D\u6B21\u63A2\u7D22\uFF0C\u53D1\u73B0\u66F4\u591A\u7EA2\u5305</span>\n                <span class="red-pag-open"></span>\n            </div>';
            this.dom = $(html);
            this.end = end;
            this.data = data;
            this.orData = orData;
            this.empty = false;
            $('.recommend').empty().append(this.dom);
            this.event();
            if (res.award == 1) {
                this.openPag(1, res.money);
            }
        }

        _createClass(RED_PAG, [{
            key: 'event',
            value: function event() {
                var that = this;
                if (qs_c_obj.isMobile()) {
                    this.dom.on('touchend', '.btn', function (e) {
                        e.stopPropagation();
                        if (read.shareTimes > 0 || that.empty) {
                            read.readAgain();
                        } else {
                            if (qs_c_obj.isWeichat()) {
                                $('body').toast('分享至微信获得1次探索机会');
                            } else {
                                var fg = $(document.createDocumentFragment());
                                fg.qrcode(that.shareObj.url);
                                read.showQr({
                                    title: '微信分享将获得1次探索机会',
                                    desc: '',
                                    img: fg.find('img').get(0)
                                });
                            }
                        }
                    });
                    this.dom.on('touchend', '.red-pag-open', function (e) {
                        e.stopPropagation();
                        that.openPag();
                    });
                } else {
                    this.dom.on('click', '.btn', function (e) {
                        e.stopPropagation();
                        if (read.shareTimes > 0 || that.empty) {
                            read.readAgain();
                        } else {
                            if (qs_c_obj.isWeichat()) {
                                $('body').toast('在微信分享将获得1次探索机会');
                            } else {
                                var fg = $(document.createDocumentFragment());
                                fg.qrcode(that.shareObj.url);
                                read.showQr({
                                    title: '微信分享将获得1次探索机会',
                                    desc: '',
                                    img: fg.find('img').get(0)
                                });
                            }
                        }
                    });
                    this.dom.on('click', '.red-pag-open', function (e) {
                        e.stopPropagation();
                        that.openPag(0);
                    });
                }
            }

            /**
             * 开红包
             * @param type 红包状态类型 0 未领过 1 已经领过
             * @param money 已经领过的金额
             */

        }, {
            key: 'openPag',
            value: function openPag(type, money) {

                var that = this,
                    params = {
                    id: pageObj.bookid,
                    pid: this.data.id,
                    or: this.orData
                };

                if (!qs_c_obj.isLogin) {
                    qs_c_obj.showLoginWin(function () {
                        window.location.reload();
                    });
                    return;
                }

                if (type == 1 && money) {
                    that.dom.addClass('red-pag-opened');
                    that.dom.find('.red-pag-money span').text(money);
                    $('.red-pag-title', this.dom).text('您已领过该结局的红包');
                } else {
                    REQUEST.getAward(params).done(function (res) {
                        if (res.status == 1) {
                            that.dom.addClass('red-pag-opened');
                            that.dom.find('.red-pag-money span').text(res.money);
                            $('.red-pag-title', that.dom).text('恭喜你抽中');
                        } else if (res.status == 2) {
                            that.dom.addClass('red-pag-opened');
                            that.dom.find('.red-pag-money span').text(res.money);
                            $('.red-pag-title', this.dom).text('您已领过该结局的红包');
                        } else if (res.status == 3) {
                            that.empty = true;
                            that.dom.addClass('red-pag-empty');
                            $('.red-pag-title', that.dom).text('红包已领完。手慢？别灰心！');
                            $('.red-pag-try', that.dom).text('到达人数最少的结局\n将产生现金大礼包');
                            $('.red-pag-desc', that.dom).text('24小时候公布，继续探索吧！');
                        } else {
                            $('body').toast('领取红包失败');
                        }
                    });
                }
            }
        }]);

        return RED_PAG;
    }();

    /**
     * 游戏阅读
     */


    var PRINTOUT = function () {
        /**
         *
         * @param {*read对象} read
         * @param {*view对象} view
         * @param {*是否需要自动加载第一段} needLoad
         */
        function PRINTOUT(read, view, needLoad) {
            _classCallCheck(this, PRINTOUT);

            if (read.loadMethod == 0) {
                read.showNext(view);
                return;
            }
            this.mode = 0;
            this.read = read;
            this.view = view;
            this.content_list = view.content_list;
            this.id = view.id;
            this.speed = qs_c_obj.isMobile() ? 1 : 2;
            this.delay = 10;
            this.index = 0;
            this.max = view.content_list.length - 1;
            this.isLoading = false;
            this.currentDom = null;
            // this.fontColor = null;
            var data = read.bookdata,
                views = read.bookView;
            this.next = views[data[view.id].sid];
            this.effect();
            this.init(needLoad);
        }

        _createClass(PRINTOUT, [{
            key: 'init',
            value: function init(needLoad) {
                var box = $('<div>');
                box.css({
                    backgroundColor: 'transparent'
                });
                this.box = box;
                this.view.insertDom = box.get(0);
                this.read.dom.find('.read-content').append(box);
                this.event();
                needLoad && this.print();
            }
        }, {
            key: 'event',
            value: function event() {
                var that = this;
                $(document).on('keydown.print', function (e) {
                    var keyCode = e.keyCode;
                    if (keyCode == 13 || keyCode == 32) {
                        // e.preventDefault();
                        var loadMethod = that.read.loadMethod,
                            current = that.currentDom;
                        current && current.classList.remove('read-loading');
                        if (loadMethod == 1) {
                            that.print();
                        } else {
                            that.loadAll();
                        }
                    }
                });
                $('.read').on('click.print', function () {
                    var loadMethod = that.read.loadMethod,
                        current = that.currentDom;
                    current && current.classList.remove('read-loading');
                    if (loadMethod == 1) {
                        that.print();
                    } else {
                        that.loadAll();
                    }
                });
            }
        }, {
            key: 'effect',
            value: function effect() {
                var res = void 0;
                if (EFFECT_ANIMATE) {
                    res = EFFECT_ANIMATE.background(this.view.id);
                }
                if (res) {
                    this.fontColor = res;
                }
            }
        }, {
            key: 'print',
            value: function print() {
                var _this2 = this;

                if (this.isLoading) return;
                this.isLoading = true;
                var that = this,
                    max = this.max,
                    index = this.index,
                    dom = this.content_list[index];
                var kw = $(dom).data('keywords');
                if (kw) {
                    EFFECT_ANIMATE.trigger(kw);
                }
                // if (this.fontColor) {
                //     $(dom).css({
                //         color: this.fontColor
                //     })
                // }
                if (this.mode == 1) {
                    this.currentDom = dom || this.currentDom;
                    dom.style.display = 'none';
                    this.box.append(dom);
                    dom.classList.add('read-loading');
                    $(dom).fadeIn('slow');
                    $('body').animate({
                        scrollTop: document.body.scrollHeight || document.documentElement.scrollHeight
                    }, 'slow', 'linear', function () {
                        if (index < max) {
                            that.index++;
                        } else {
                            that.done();
                        }
                        that.isLoading = false;
                    });
                } else {
                    var pms = this.animate(dom, this.box, true);
                    dom.classList.add('read-loading');
                    this.currentDom = dom;
                    pms.then(function () {
                        _this2.isLoading = false;
                        // dom.classList.remove('read-loading');
                        if (index < max) {
                            _this2.index++;
                        } else {
                            _this2.done();
                        }
                    });
                }
            }

            /**
             *
             * @param {*需要处理的dom} dom
             * @param {*父级节点} pDom
             * @param {*是否需要添加read-text class} needClass
             */

        }, {
            key: 'animate',
            value: function animate(dom, pDom, needClass) {
                var that = this,
                    index = 0,
                    list = [],
                    _list = dom.childNodes;
                //将节点的内容拷贝到list数组里面等待处理
                for (var i = 0, l = _list.length; i < l; i++) {
                    var item = _list[i],
                        type = item.nodeType;
                    if (type == Node.TEXT_NODE) {
                        list.push(item.nodeValue);
                    } else {
                        list.push(item.cloneNode(true));
                    }
                }
                dom.innerHTML = '';
                pDom.append(dom);
                needClass && dom.classList.add('read-text');

                /**
                 *
                 * @param {*传入父级promise的resolve函数，在必要时执行} resolve
                 */
                var length = list.length;

                function printNoop(resolve) {
                    var item = list[index];
                    if (typeof item == 'string') {
                        var pms = that.printStr(dom, item);
                        pms.then(function () {
                            if (index < length - 1) {
                                index++;
                                printNoop(resolve);
                            } else {
                                resolve();
                            }
                        });
                    } else {
                        var _pms = that.animate(item, $(dom));
                        _pms.then(function () {
                            if (index < length - 1) {
                                index++;
                                printNoop(resolve);
                            } else {
                                resolve();
                            }
                        });
                    }
                }

                //返回promise对象给print
                return new Promise(function (resolve, reject) {
                    if (list && list.length) {
                        printNoop(resolve);
                    } else {
                        resolve();
                    }
                });
            }
        }, {
            key: 'printStr',
            value: function printStr(dom, content) {
                var that = this,
                    delay = this.delay,
                    animateFlag = void 0;
                return new Promise(function (resolve, reject) {
                    var _index = 0,
                        speed = that.speed;
                    content = content.replace(/&nbsp;/igm, '▼'); //使用不常见符号占位 避免出现将所有空格换成nbsp之后不能换行情况
                    var render = function render() {
                        var tempStr = content.slice(_index, _index + speed);
                        tempStr = tempStr.replace(/▼/igm, '&nbsp;');
                        dom.innerHTML += tempStr;
                        dom.scrollIntoView(); //重置焦点
                        if (_index >= content.length) {
                            cancelAnimationFrame(animateFlag);
                            resolve();
                        } else {
                            if (delay) {
                                setTimeout(function () {
                                    requestAnimationFrame(render);
                                }, delay);
                            } else {
                                requestAnimationFrame(render);
                            }
                        }
                        _index += speed;
                    };
                    animateFlag = requestAnimationFrame(render);
                });
            }
        }, {
            key: 'fade',
            value: function fade() {}
        }, {
            key: 'loadAll',
            value: function loadAll() {
                if (this.isLoading) return;
                this.isLoading = true;
                var index = this.index,
                    content_list = this.content_list,
                    list = content_list.slice(index),
                    fg = document.createDocumentFragment();
                list.forEach(function (v) {
                    v.classList.add('read-text');
                    fg.appendChild(v);
                });
                this.box.append(fg);
                this.done(true);
            }

            /**
             *
             * @param {*boolean} type  true：不滚动到or 否则滚动到or
             */

        }, {
            key: 'done',
            value: function done(type) {
                var _this3 = this;

                $(document).off('.print');
                $('.read').off('.print');
                $(this.currentDom).removeClass('read-loading');
                $('#readCont').find('.read-loading').removeClass('read-loading');
                var next = this.next;
                if (next) {
                    /*用于处理段落后面接段落会自动连续加载问题*/
                    if (next.type != 1) {
                        this.read.showNext(next);
                        !type && next.scrollTo();
                    } else {
                        this.read.showList.push(next);
                        read.activePrint = new PRINTOUT(this.read, next);
                    }
                } else {
                    this.read.showEnd(this.view, function () {
                        var scrollTop = $('body').scrollTop();
                        if (_this3.mode != 1) {
                            $('body').animate({
                                scrollTop: scrollTop + 300
                            }, 300);
                        }
                    });
                }
            }
        }]);

        return PRINTOUT;
    }();

    /**
     * 微信支付
     */


    var WEICHAT_PAY = function () {
        function WEICHAT_PAY(read, data) {
            _classCallCheck(this, WEICHAT_PAY);

            this.data = data;
            this.read = read;
            this.params = null;
            this.getParams();
        }

        _createClass(WEICHAT_PAY, [{
            key: 'getParams',
            value: function getParams() {
                var that = this;
                REQUEST.mobile_wx_pay().done(function (res) {
                    if (res.status == 1) {
                        that.params = JSON.parse(res.jsApiParameters);
                        that.trigger();
                    }
                });
            }
        }, {
            key: 'trigger',
            value: function trigger() {
                var that = this,
                    params = this.params;
                if (!params) return;
                WeixinJSBridge.invoke('getBrandWCPayRequest', params, function (res) {
                    that.callback(res);
                    that.params = null;
                });
            }
        }, {
            key: 'callback',
            value: function callback(res) {
                var that = this;
                switch (res.err_msg) {
                    case 'get_brand_wcpay_request:ok':
                        {
                            that.checkPay();
                            break;
                        }
                    case 'get_brand_wcpay_request:cancel':
                        {
                            console.log('取消');
                            break;
                        }
                    case 'get_brand_wcpay_request:fail':
                        {
                            console.log('失败');
                            break;
                        }
                }
                this.params = null;
            }
        }, {
            key: 'checkPay',
            value: function checkPay() {
                var that = this,
                    data = that.data;
                var timer = setInterval(function () {
                    REQUEST.checkBuy().done(function (res) {
                        if (res.status == 1) {
                            that.read.checkPay(data);
                            clearInterval(timer);
                        }
                    });
                }, 2000);
            }
        }]);

        return WEICHAT_PAY;
    }();

    /**
     * 阅读进度
     */


    var READ_PROCESS = function () {
        /**
         * @return {null}
         */
        function READ_PROCESS(result, count) {
            _classCallCheck(this, READ_PROCESS);

            this.data = result;
            this.count = count;
            this.isUpdate = result.is_update;
            this.start_process = result.read_per;
            this.process = 0;
            this.status = true;
            this.dom = null;
            this.text = null;
            this.length = 0;
            this.delay = 300;
            this.circle = null;
            this.default_length = 112.369;
            this.init();
        }

        _createClass(READ_PROCESS, [{
            key: 'init',
            value: function init() {
                if (this.count === 0) {
                    this.status = false;
                    this.start_process = 100;
                }
                if (this.isUpdate) {
                    $('body').toast('这篇巧书已经更新，完成度归 0 ～');
                }
                var html = '<li class="menu-list-item-process">\n                        <svg width="38" height="38" xmlns="http://www.w3.org/2000/svg" version="1.1">\n                            <circle r="18" cy="19" cx="19" stroke-width="1" stroke="#2D3033" fill="none" style=""></circle>\n                            <circle r="18" cy="19" cx="19" stroke-width="1" stroke="#4886FF" fill="none" style="\n                                transform: rotate(-90deg);\n                                transform-origin: center;\n                                stroke: #4886FF;\n                                stroke-width: 2px;\n                                transition: all ' + this.delay * 0.001 + 's linear;\n                                stroke-dasharray: ' + this.default_length + ';\n                                stroke-dashoffset: ' + this.default_length + ';\n                            "></circle>\n                        </svg>\n                        <span>0%</span>\n                    </li>',
                    dom = $(html);
                this.dom = dom;
                this.text = dom.find('span');
                $('#read-menu').find('.menu-left').append(dom);
                var circle = dom.find('circle').get(1);
                this.circle = circle;
                this.length = circle.getTotalLength ? circle.getTotalLength() : this.default_length;

                this.start();
            }
        }, {
            key: 'start',
            value: function start() {
                var _this4 = this;

                this.update(100);

                setTimeout(function () {
                    _this4.update(_this4.start_process);
                }, this.delay);
            }
        }, {
            key: 'update',
            value: function update(process, view, lr) {
                var _process = this.process,
                    short = process - _process;
                if (view) {
                    if (short) {
                        this.updateView(process);
                        this.toast(view, process, lr);
                        this.process = process;
                    }
                } else {
                    this.updateView(process);
                    this.process = process;
                }
            }
        }, {
            key: 'updateView',
            value: function updateView(process) {
                var dom = this.circle,
                    lth = this.length * (1 - process * 0.01);
                $(dom).css({
                    strokeDasharray: this.length,
                    strokeDashoffset: lth
                });
                this.updateNumber(process);
            }
        }, {
            key: 'updateNumber',
            value: function updateNumber(process) {
                var dom = this.text,
                    _process = this.process,
                    sort = process - _process,
                    time = this.delay,
                    timer = null,
                    speed = 20,
                    times = time / speed;
                timer = setInterval(function () {
                    var num = _process += sort / times;
                    num = num.toFixed(1);
                    dom.html(num + '%');
                    time -= speed;
                    if (time <= 0) {
                        dom.html(process + '%');
                        clearInterval(timer);
                    }
                }, speed);
            }
        }, {
            key: 'toast',
            value: function toast(view, process, lr) {
                var _process = this.process,
                    sort = process - _process,
                    method = lr ? 'right' : 'left',
                    dom = view[method],
                    toast = $('<span class="animate-read-process-toast">\u5B8C\u6210\u5EA6+' + sort.toFixed(1) + '%</span>').get(0);
                dom.appendChild(toast);
                setTimeout(function () {
                    toast.remove();
                }, 800);
            }
        }]);

        return READ_PROCESS;
    }();

    /**
     *事件绑定
     * */


    var EVENT = {
        mbEvent: {
            'touchend|#nav': function touchendNav(e) {
                e.stopPropagation();
            },
            'touchend|window': function touchendWindow() {
                // read.showTeb(!read.isTebShow);
            },
            'touchmove.load|.read': function touchmoveLoadRead(e) {
                var body = $('body');
                if (read.firstLoad || read.titleShow) {
                    read.isLoad = true;
                    read.firstLoad = false;
                    setTimeout(function () {
                        read.isLoad = false;
                    }, read.loadTime);
                    return;
                }
                if (!read.canLoad || read.orData.length <= 0 || read.isLoad || !read.ready || body.scrollTop() > 0) {
                    $.noop();
                } else {
                    read.isLoad = true;
                    $('#readCont').loader2(true);
                    $(this).one('touchend.load', function (e) {
                        e.stopPropagation();
                        // body.off('touchend.load');
                        $('#readCont').removeLoader2();
                        var showList = read.showList,
                            view = read.bookView,
                            first = showList[0];
                        if (read.ready && first.type != 1) {
                            read.isLoad = true;
                            var curr = showList[0],
                                top = curr.dom.offsetTop,
                                pItem = view[curr.data[0].pid];

                            /*上下控制or记录*/
                            read.currentOr = curr;
                            /*上下控制or记录*/

                            if (pItem) read.showPre(pItem);
                            if (read.showList[0].data.pid == 0) {
                                $('.read-title').show();
                                read.canLoad = false;
                            }
                            var scrollTop = curr.dom.offsetTop;
                            $("body").scrollTop(scrollTop - top);
                            read.orBtnRender();
                        }

                        setTimeout(function () {
                            read.isLoad = false;
                        }, 600);
                    });
                }
            },
            'touchend|.icon-like,.icon-liked': function touchendIconLikeIconLiked(e) {
                e.stopPropagation();
                read.doMark();
            },
            'touchend|.load-item-left': function touchendLoadItemLeft(e) {
                e.stopPropagation();
                read.changeLoadMode(0);
            },
            'touchend|.load-item-right': function touchendLoadItemRight(e) {
                e.stopPropagation();
                read.changeLoadMode(1);
            },
            'touchend|#dark': function touchendDark(e) {
                e.stopPropagation();
                read.switch();
            },
            'touchend|#read-end': function touchendReadEnd(e) {
                e.stopPropagation();
                location.href += '';
                // if (qs_c_obj.isLogin || pageObj.isApp == 1) {
                //     read.readAgain();
                // } else {
                //     qs_c_obj.setCookie('qs_clear_bid', pageObj.bookid, 1);
                //     read.jumpToLogin();
                // }
            },
            'touchend|#branch': function touchendBranch(e) {
                e.stopPropagation();
                var branch = $('.branch-control'),
                    flag = branch.data('flag');
                read.showBranch(!flag);
            },
            'touchend|.branch-pre': function touchendBranchPre(e) {
                e.stopPropagation();
                if (!$(this).hasClass('disable')) {
                    read.orSelect(0);
                }
            },
            'touchend|.branch-next': function touchendBranchNext(e) {
                e.stopPropagation();
                if (!$(this).hasClass('disable')) {
                    read.orSelect(1);
                }
            },
            'touchend|.branch-jump': function touchendBranchJump(e) {
                e.stopPropagation();
                if (!$(this).hasClass('disable')) {
                    read.orSelect(2);
                }
            },
            'touchend|body': function touchendBody(e) {
                // e.stopPropagation();
                read.showBranch(false);
            }

        },

        pcEvent: {
            'click|.icon-weichat': function clickIconWeichat() {
                var fg = $(document.createDocumentFragment());
                fg.qrcode(read.shareObj.url);
                read.showQr({
                    title: '微信分享',
                    desc: '',
                    img: fg.find('img').get(0)
                });
            },
            'click|#read-end': function clickReadEnd() {
                location.href += '';

                // if (qs_c_obj.isLogin || pageObj.isApp == 1) {
                //     read.readAgain();
                // } else {
                //     qs_c_obj.setCookie('qs_clear_bid', pageObj.bookid, 1);
                //     qs_c_obj.showLoginWin(function () {
                //         read.readAgain();
                //     });
                // }
            },
            'click|.icon-like,.icon-liked': function clickIconLikeIconLiked() {
                read.doMark();
            },
            'click|.branch-pre': function clickBranchPre(e) {
                e.stopPropagation();
                if (!$(this).hasClass('disable')) {
                    read.orSelect(0);
                }
            },
            'click|.branch-next': function clickBranchNext(e) {
                e.stopPropagation();
                if (!$(this).hasClass('disable')) {
                    read.orSelect(1);
                }
            },
            'click|.branch-jump': function clickBranchJump(e) {
                e.stopPropagation();
                if (!$(this).hasClass('disable')) {
                    read.orSelect(2);
                }
            },
            'click|.load-item-left': function clickLoadItemLeft(e) {
                e.stopPropagation();
                read.changeLoadMode(0);
            },
            'click|.load-item-right': function clickLoadItemRight(e) {
                e.stopPropagation();
                read.changeLoadMode(1);
            },
            'click|#dark': function clickDark() {
                read.switch();
            },
            'resize|window': function resizeWindow() {
                var left = $('.read-box').offset().left;
                $('.read-share').css({
                    left: left - 148
                });
            },
            'click|#branch': function clickBranch(e) {
                e.stopPropagation();
                var branch = $('.branch-control'),
                    flag = branch.data('flag');
                read.showBranch(!flag);
            },
            'click|body': function clickBody() {
                read.showBranch(false);
            }
        }
    };

    $(function () {
        $('body').loader().loader();
        if (pageObj.effect_article || pageObj.effect_global || pageObj.effect_keywords) {
            // feature = new FEATURE(pageObj.effect_global ,pageObj.effect_article, pageObj.effect_keywords,()=>{read = new READ()});
            EFFECT_ANIMATE = new ANIMATE(pageObj.effect_global, pageObj.effect_article, pageObj.effect_keywords, function () {
                qs_c_obj.isDebug || pageObj.isApp || qs_c_obj.isTest ? window.read = read = new READ() : read = new READ();
            });
        } else {
            qs_c_obj.isDebug || pageObj.isApp || qs_c_obj.isTest ? window.read = read = new READ() : read = new READ();
        }
        $(document).on('contextmenu', function () {
            if (location.href.indexOf('qiaobooks') >= 0) {
                return false;
            }
        });
    });

    window._debug = function () {
        return read;
    };
})(jQuery);